using System;
using System.Data;
using System.Data.SqlClient;
using Method = System.Reflection.MethodBase;
using TABLE = gov.va.med.vbecs.Common.VbecsTables;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;

namespace gov.va.med.vbecs.BOL
{
	/// <summary>
	/// Summary description for PatientTransfusionRequirement.
	/// </summary>
	public class PatientTransfusionRequirement : BaseBusinessObject, IRecordStatusCode
	{
		#region Variables

		private string _createDivisionCode;
		private string _createUser;
		private string _inactivationComment;
		private string _inactivateDivisionCode;
		private string _inactivateUser;
		private string _transfusionRequirement;
		
		private System.DateTime _createDate;
		private System.DateTime _inactivateDate;
		
		private bool _vistaConversionIndicator;

		private int _antibodyTypeId;
		private int _antigenTypeId;
		private int _componentRequirementId;
		
		private Guid _patientGUID;
		private Guid _specimenTestGuid;
		private Guid _transfusionRequirementGUID;

		private Common.RecordStatusCode _statusCode;

		private Common.TransfusionRequirementCategoryCode _transfusionRequirementCategoryCode;

		#endregion

		#region constructors

		///<Developers>
		///	<Developer>Carl Jensen</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>8/14/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="3181"> 
		///		<ExpectedInput>Valid parameters</ExpectedInput>
		///		<ExpectedOutput>PatientTransfusionRequirement object</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="3182"> 
		///		<ExpectedInput>Invalid parameters</ExpectedInput>
		///		<ExpectedOutput>BusinessObjectException</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Constructor
		/// </summary>
		/// <param name="patient"></param>
		/// <param name="transfusionRequirement"></param>
		/// <param name="transfusionRequirementType"></param>
		/// <param name="createDivisionCode"></param>
		public PatientTransfusionRequirement(BOL.Patient patient, string transfusionRequirement, Common.TransfusionRequirementCategoryCode transfusionRequirementType, string createDivisionCode)
		{
			this.TransfusionRequirementCategoryCode = transfusionRequirementType;
			this.TransfusionRequirementGuid = System.Guid.NewGuid();
			System.DateTime currentDate = VBECSDateTime.GetDivisionCurrentDateTime();

			if (patient == null) 
			{
				string errorMessage = Common.StrRes.SysErrMsg.Common.InvalidPropertyOrMethod(
										Common.Utility.ParseStringwithSpaces(Method.GetCurrentMethod().Name),
										"patient may not be null").ResString;
				throw new BusinessObjectException(errorMessage);
			}
			this._patientGUID = patient.PatientGuid;
			this.TransfusionRequirement = transfusionRequirement;
			this.VistaConversionIndicator = false;
			this.RecordStatusCode = Common.RecordStatusCode.Active;
			this.LastUpdateDate = currentDate;
			this.CreateDate = currentDate;
			this.CreateUser = Common.LogonUser.LogonUserName;
			this.CreateDivisionCode = createDivisionCode;
		}

		///<Developers>
		///	<Developer>Carl Jensen</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>8/14/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="3197"> 
		///		<ExpectedInput>Valid DataRow</ExpectedInput>
		///		<ExpectedOutput>PatientTransfusionRequirement object</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="3198"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///<summary>
		/// Constructor
		///</summary>
		///<param name="dr"></param>
		public PatientTransfusionRequirement(DataRow dr)
		{
			this.LoadFromDataRow(dr);
		}

		#endregion


		#region properties

		///<Developers>
		///	<Developer>Carl Jensen</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>4/17/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="2616"> 
		///		<ExpectedInput>Common.TransfusionRequirementCategoryCode</ExpectedInput>
		///		<ExpectedOutput>Common.TransfusionRequirementCategoryCode</ExpectedOutput>
		///	</Case>
		///	
		///<Case type="1" testid ="489"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// TransfusionRequirementCategoryCode
		/// </summary>
		public Common.TransfusionRequirementCategoryCode TransfusionRequirementCategoryCode
		{
			get
			{
				return _transfusionRequirementCategoryCode;
			}
			set
			{
				_transfusionRequirementCategoryCode = value;
			}
		}

		///<Developers>
		///	<Developer>Carl Jensen</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>4/17/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="2618"> 
		///		<ExpectedInput>Guid</ExpectedInput>
		///		<ExpectedOutput>Guid</ExpectedOutput>
		///	</Case>
		///	
		///<Case type="1" testid ="490"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// TransfusionRequirementGuid
		/// </summary>
		public Guid TransfusionRequirementGuid
		{
			get
			{
				return _transfusionRequirementGUID;
			}
			set
			{
				_transfusionRequirementGUID = value;
			}
		}

		///<Developers>
		///	<Developer>Carl Jensen</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>4/17/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="2620"> 
		///		<ExpectedInput>string</ExpectedInput>
		///		<ExpectedOutput>string</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="2621"> 
		///		<ExpectedInput>Invalid string</ExpectedInput>
		///		<ExpectedOutput>BusinessObjectException</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// TransfusionRequirement
		/// </summary>
		public string TransfusionRequirement
		{
			get
			{
				return this._transfusionRequirement;
			}
			set
			{
				if (value == null || value.Trim().Length == 0)
				{
					string errorMessage = Common.StrRes.SysErrMsg.Common.FieldLengthError(
											Common.Utility.ParseStringwithSpaces(Method.GetCurrentMethod().Name, true),
											"0", "256").ResString;
					throw new BusinessObjectException(errorMessage);
				}
				else
				{
					_transfusionRequirement = value;
				}
			}
		}

		///<Developers>
		///	<Developer>Carl Jensen</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>4/17/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="2622"> 
		///		<ExpectedInput>Valid date</ExpectedInput>
		///		<ExpectedOutput>Date</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="2623"> 
		///		<ExpectedInput>Invalid date (set to Date.MinValue)</ExpectedInput>
		///		<ExpectedOutput>BusinessObjectException</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// CreateDate
		/// </summary>
		public System.DateTime CreateDate
		{
			get
			{
				return _createDate;
			}
			set
			{
				if (value == DateTime.MinValue || value == DateTime.MaxValue)
				{


					string errorMessage = Common.StrRes.SysErrMsg.Common.InvalidPropertyOrMethod(
											Common.Utility.ParseStringwithSpaces(Method.GetCurrentMethod().Name, true),
											value).ResString;
					throw new BOL.BusinessObjectException(errorMessage);
				}
				else
				{
					_createDate = value;
				}
			}
		}

		///<Developers>
		///	<Developer>Carl Jensen</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>4/17/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="2624"> 
		///		<ExpectedInput>string</ExpectedInput>
		///		<ExpectedOutput>string</ExpectedOutput>
		///	</Case>
		///	
		///<Case type="1" testid ="481"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// CreateUser
		/// </summary>
		public string CreateUser
		{
			get
			{
				return _createUser;
			}
			set
			{
				_createUser = value;
			}
		}

		///<Developers>
		///	<Developer>Carl Jensen</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>4/17/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="2628"> 
		///		<ExpectedInput>bool</ExpectedInput>
		///		<ExpectedOutput>bool</ExpectedOutput>
		///	</Case>
		///	
		///<Case type="1" testid ="491"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// VistaConversionIndicator
		/// </summary>
		public bool VistaConversionIndicator
		{
			get
			{
				return _vistaConversionIndicator;
			}
			set
			{
				_vistaConversionIndicator = value;
			}
		}

		///<Developers>
		///	<Developer>Carl Jensen</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>4/17/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="2630"> 
		///		<ExpectedInput>int</ExpectedInput>
		///		<ExpectedOutput>int</ExpectedOutput>
		///	</Case>
		///	
		///<Case type="1" testid ="478"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// AntibodyTypeId
		/// </summary>
		public int AntibodyTypeId
		{
			get
			{
				return _antibodyTypeId;
			}
			set
			{
				_antibodyTypeId = value;
			}
		}

		///<Developers>
		///	<Developer>C. Jensen</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>3/14/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="7036"> 
		///		<ExpectedInput>Valid Parameters</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///
		///<Case type="1" testid ="7037"> 
		///		<ExpectedInput>Invalid Parameters</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Antigen type id
		/// </summary>
		public int AntigenTypeId
		{
			get
			{
				return _antigenTypeId;
			}
			set
			{
				_antigenTypeId = value;
			}
		}

		///<Developers>
		///	<Developer>Carl Jensen</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>6/26/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="2959"> 
		///		<ExpectedInput>int</ExpectedInput>
		///		<ExpectedOutput>int</ExpectedOutput>
		///	</Case>
		///	
		///<Case type="1" testid ="479"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// ComponentRequirementId
		/// </summary>
		public int ComponentRequirementId
		{
			get
			{
				return this._componentRequirementId;
			}
			set
			{
				this._componentRequirementId = value;
			}
		}

		///<Developers>
		///	<Developer>Carl Jensen</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>4/17/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="2632"> 
		///		<ExpectedInput>string</ExpectedInput>
		///		<ExpectedOutput>string</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="2633"> 
		///		<ExpectedInput>Comment of no length</ExpectedInput>
		///		<ExpectedOutput>BusinessObjectException</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// InactivationComment
		/// </summary>
		public string InactivationComment
		{
			get
			{
				return this._inactivationComment;
			}
			set
			{
				if (value.Trim().Length == 0  || value.Trim().Length > 255)
				{
					string errorMessage = Common.StrRes.SysErrMsg.Common.FieldLengthError(
											Common.Utility.ParseStringwithSpaces(Method.GetCurrentMethod().Name, true),
											"0", "256").ResString;
					throw new BusinessObjectException(errorMessage);
				}
				else
				{
					this._inactivationComment = value;
				}
			}
		}

	

		///<Developers>
		///	<Developer>Carl Jensen</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>4/17/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="2636"> 
		///		<ExpectedInput>DateTime</ExpectedInput>
		///		<ExpectedOutput>DateTime</ExpectedOutput>
		///	</Case>
		///	
		///<Case type="1" testid ="482"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// InactivateDate
		/// </summary>
		public System.DateTime InactivateDate
		{
			get
			{
				return this._inactivateDate;
			}
			set
			{
				this._inactivateDate = value;
			}
		}

		///<Developers>
		///	<Developer>COE User</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>4/17/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="2642"> 
		///		<ExpectedInput>string</ExpectedInput>
		///		<ExpectedOutput>string</ExpectedOutput>
		///	</Case>
		///	
		///<Case type="1" testid ="484"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// InactivateUser
		/// </summary>
		public string InactivateUser
		{
			get
			{
				return this._inactivateUser;
			}
			set
			{
				this._inactivateUser = value;
			}
		}

		///<Developers>
		///	<Developer>Carl Jensen</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>4/17/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="2640"> 
		///		<ExpectedInput>string</ExpectedInput>
		///		<ExpectedOutput>string</ExpectedOutput>
		///	</Case>
		///	
		///<Case type="1" testid ="480"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// CreateDivisionCode
		/// </summary>
		public string CreateDivisionCode
		{
			get
			{
				return this._createDivisionCode;
			}
			set
			{
				this._createDivisionCode = value;
			}
		}

		///<Developers>
		///	<Developer>Carl Jensen</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>8/15/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="3227"> 
		///		<ExpectedInput>string</ExpectedInput>
		///		<ExpectedOutput>string</ExpectedOutput>
		///	</Case>
		///	
		///<Case type="1" testid ="483"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///<summary>
		/// InactivateDivisionCode
		///</summary>
		public string InactivateDivisionCode
		{
			get
			{
				return this._inactivateDivisionCode;
			}
			set
			{
				this._inactivateDivisionCode = value;
			}
		}

		///<Developers>
		///	<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>8/13/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="7569"> 
		///		<ExpectedInput>Valid Parameters</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="7570"> 
		///		<ExpectedInput>Invalid Parameters</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// SpecimenTestGuid
		/// </summary>
		public Guid SpecimenTestGuid
		{
			get
			{
				return this._specimenTestGuid;
			}
			set
			{
				this._specimenTestGuid = value;
			}
		}

		///<Developers>
		///	<Developer>Carl Jensen</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>4/17/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="2638"> 
		///		<ExpectedInput>Common.RecordStatusCode</ExpectedInput>
		///		<ExpectedOutput>Common.RecordStatusCode</ExpectedOutput>
		///	</Case>
		///	
		///<Case type="1" testid ="488"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// RecordStatusCode
		/// </summary>
		public Common.RecordStatusCode RecordStatusCode
		{
			get
			{
				return this._statusCode;
			}
			set
			{
				this._statusCode = value;
			}
		}

		#endregion


		#region methods

		///<Developers>
		///	<Developer>COE User</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>4/17/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="2644"> 
		///		<ExpectedInput>Valid patient GUID</ExpectedInput>
		///		<ExpectedOutput>Valid data table with > 0 rows</ExpectedOutput>
		///	</Case>
		///
		///<Case type="0" testid ="9158"> 
		///		<ExpectedInput>Valid patient GUID</ExpectedInput>
		///		<ExpectedOutput>Data table with TRs from conversion</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="2645"> 
		///		<ExpectedInput>Invalid patient GUID</ExpectedInput>
		///		<ExpectedOutput>Data table with no rows</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Get transfusion requirements for the patient
		/// </summary>
		/// <param name="patientGuid"></param>
		/// <returns></returns>
		public static DataTable GetTransfusionRequirementsForPatient(Guid patientGuid)
		{
			DataTable dtTransfusionRequirements = DAL.PatientTransfusionRequirement.GetTransfusionRequirementsForPatient(patientGuid);
			return dtTransfusionRequirements;
		}
		
		///<Developers>
		///	<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>8/13/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="7571"> 
		///		<ExpectedInput>Patient with transfusion requirements</ExpectedInput>
		///		<ExpectedOutput>true</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="7572"> 
		///		<ExpectedInput>Patient with no transfusion requirements</ExpectedInput>
		///		<ExpectedOutput>false</ExpectedOutput>
		///	</Case>
		///	
		///<Case type="0" testid ="9165"> 
		///		<ExpectedInput>Patient with TRs from conversion</ExpectedInput>
		///		<ExpectedOutput>true</ExpectedOutput>
		///	</Case>
		///
		///<Case type="0" testid ="8440"> 
		///		<ExpectedInput>Invalid patient (empty Guid</ExpectedInput>
		///		<ExpectedOutput>Argument exception</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// DoTransfusionRequirementsExistForPatient
		/// </summary>
		/// <param name="patientGuid"></param>
		/// <returns>True or False</returns>
		public static bool DoTransfusionRequirementsExistForPatient(Guid patientGuid)
		{
			if (patientGuid == Guid.Empty)
			{
				throw new ArgumentException("Invalid InvoiceNumber argument", "value");
			}
			DataTable dtTransfusionRequirements = DAL.PatientTransfusionRequirement.GetTransfusionRequirementsForPatient(patientGuid);
			DataRow [] drArray = dtTransfusionRequirements.Select("RecordStatusCode = '" + Common.Utility.GetRecordStatusCodeCharFromEnum(Common.RecordStatusCode.Active) + "' OR RecordStatusCode = '" + Common.Utility.GetRecordStatusCodeCharFromEnum(Common.RecordStatusCode.Converted) + "'" );
			if (drArray != null && drArray.Length > 0) return true;
			else return false;
		}

		///<Developers>
		///	<Developer>Carl Jensen</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>8/14/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="3195"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>DataTable</ExpectedOutput>
		///	</Case>
		///	
		///<Case type="1" testid ="486"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Returns an empty TransfusionRequirements data table
		/// </summary>
		/// <param name="isUpdate"></param>
		/// <returns></returns>
		public static DataTable InitializeTransfusionRequirementsTable(bool isUpdate)
		{
			DataTable dtTransfusionRequirements = new DataTable(TABLE.PatientTransfusionRequirement.TableName);

			dtTransfusionRequirements.Columns.Add(TABLE.PatientTransfusionRequirement.PatientTransfusionRequirementGuid, typeof(System.Guid));	//Required
			dtTransfusionRequirements.Columns.Add(TABLE.PatientTransfusionRequirement.PatientGuid, typeof(System.Guid));							//Required
			dtTransfusionRequirements.Columns.Add(TABLE.PatientTransfusionRequirement.TransfusionRequirementText, typeof(string));				//Required
			dtTransfusionRequirements.Columns.Add(TABLE.PatientTransfusionRequirement.TransfusionRequirementCategoryCode, typeof(string));		//Required
			dtTransfusionRequirements.Columns.Add(TABLE.PatientTransfusionRequirement.CreateDate, typeof(System.DateTime));						//Required
			dtTransfusionRequirements.Columns.Add(TABLE.PatientTransfusionRequirement.CreateUser, typeof(string));
			dtTransfusionRequirements.Columns.Add(TABLE.PatientTransfusionRequirement.CreateDivisionCode, typeof(string));
			dtTransfusionRequirements.Columns.Add(TABLE.PatientTransfusionRequirement.VistaConversionIndicator, typeof(bool));
			dtTransfusionRequirements.Columns.Add(TABLE.PatientTransfusionRequirement.AntibodyTypeId, typeof(int));
			dtTransfusionRequirements.Columns.Add(TABLE.PatientTransfusionRequirement.AntigenTypeId, typeof(int));
			dtTransfusionRequirements.Columns.Add(TABLE.PatientTransfusionRequirement.AntibodyLastLocation, typeof(string));
			dtTransfusionRequirements.Columns.Add(TABLE.PatientTransfusionRequirement.ComponentRequirementId, typeof(string));
			dtTransfusionRequirements.Columns.Add(TABLE.PatientTransfusionRequirement.InactivationComment, typeof(string));
			dtTransfusionRequirements.Columns.Add(TABLE.PatientTransfusionRequirement.InactivateDate, typeof(System.DateTime));
			dtTransfusionRequirements.Columns.Add(TABLE.PatientTransfusionRequirement.InactivateUser, typeof(string));
			dtTransfusionRequirements.Columns.Add(TABLE.PatientTransfusionRequirement.InactivateDivisionCode, typeof(string));								
			dtTransfusionRequirements.Columns.Add(TABLE.PatientTransfusionRequirement.RecordStatusCode, typeof(string));							//Required
			dtTransfusionRequirements.Columns.Add(TABLE.PatientTransfusionRequirement.LastUpdateUser, typeof(string));							//Required
			dtTransfusionRequirements.Columns.Add(TABLE.PatientTransfusion.DivisionCode, typeof(string));
			dtTransfusionRequirements.Columns.Add(TABLE.PatientTransfusionRequirement.SpecimenTestGuid, typeof(System.Guid));

			if (isUpdate)
				dtTransfusionRequirements.Columns.Add(TABLE.PatientTransfusionRequirement.RowVersion, typeof(byte[]));								//Required

			return dtTransfusionRequirements;
		}

		///<Developers>
		///	<Developer>Carl Jensen</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>4/17/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="2646"> 
		///		<ExpectedInput>Valid data row</ExpectedInput>
		///		<ExpectedOutput>Valid data row</ExpectedOutput>
		///	</Case>
		///	
		///<Case type="1" testid ="487"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		///  Loads a data row from an object
		/// </summary>
		/// <param name="dtRow"></param>
		/// <returns>Data row</returns>
		public override System.Data.DataRow LoadDataRowFromThis(System.Data.DataRow dtRow)
		{
			return dtRow;
		}
		
		/// <summary>
		/// LoadFromDataRow
		/// </summary>
		/// <param name="dtRow"></param>
		protected override void LoadFromDataRow(System.Data.DataRow dtRow)
		{
			if (dtRow.Table.Columns.Contains(TABLE.PatientTransfusionRequirement.PatientTransfusionRequirementGuid))
			{
				this.TransfusionRequirementGuid = new Guid(dtRow[TABLE.PatientTransfusionRequirement.PatientTransfusionRequirementGuid].ToString());
			}
			if (dtRow.Table.Columns.Contains(TABLE.PatientTransfusionRequirement.TransfusionRequirementCategoryCode))
			{
				this.TransfusionRequirementCategoryCode = Common.Utility.GetTransfusionCategoryCodeFromString( dtRow[TABLE.PatientTransfusionRequirement.TransfusionRequirementCategoryCode].ToString() );
			}
			if (dtRow.Table.Columns.Contains(TABLE.PatientTransfusionRequirement.TransfusionRequirementText))
			{
				this.TransfusionRequirement = dtRow[TABLE.PatientTransfusionRequirement.TransfusionRequirementText].ToString();
			}
			if (dtRow.Table.Columns.Contains(TABLE.PatientTransfusionRequirement.CreateDate))
			{
				this.CreateDate  = (System.DateTime) dtRow[TABLE.PatientTransfusionRequirement.CreateDate];
			}
			if (dtRow.Table.Columns.Contains(TABLE.PatientTransfusionRequirement.CreateUser))
			{
				this.CreateUser  = dtRow[TABLE.PatientTransfusionRequirement.CreateUser].ToString();
			}
			if (dtRow.Table.Columns.Contains(TABLE.PatientTransfusionRequirement.CreateDivisionCode))
			{
				this.CreateDivisionCode = dtRow[TABLE.PatientTransfusionRequirement.CreateDivisionCode].ToString();
			}
			if (dtRow.Table.Columns.Contains(TABLE.PatientTransfusionRequirement.VistaConversionIndicator))
			{
				this.VistaConversionIndicator = (bool) dtRow[TABLE.PatientTransfusionRequirement.VistaConversionIndicator];
			}
			if (dtRow.Table.Columns.Contains(TABLE.PatientTransfusionRequirement.AntibodyTypeId) && !dtRow.IsNull("AntibodyTypeId") && this.TransfusionRequirementCategoryCode == Common.TransfusionRequirementCategoryCode.AntibodyIdentified)
			{
				this.AntibodyTypeId = (int) dtRow[TABLE.PatientTransfusionRequirement.AntibodyTypeId];
			}
			if (dtRow.Table.Columns.Contains(TABLE.PatientTransfusionRequirement.ComponentRequirementId) && !dtRow.IsNull(TABLE.PatientTransfusionRequirement.ComponentRequirementId) && this.TransfusionRequirementCategoryCode == Common.TransfusionRequirementCategoryCode.ComponentRequirement)
			{
				this.ComponentRequirementId = (byte) dtRow[TABLE.PatientTransfusionRequirement.ComponentRequirementId];
			}
			if (dtRow.Table.Columns.Contains(TABLE.PatientTransfusionRequirement.InactivationComment))
			{
				if (!dtRow.IsNull(TABLE.PatientTransfusionRequirement.InactivationComment)) this.InactivationComment = dtRow[TABLE.PatientTransfusionRequirement.InactivationComment].ToString();
			}
			if (dtRow.Table.Columns.Contains(TABLE.PatientTransfusionRequirement.InactivateDate))
			{
				//dataRow["LocalSupplierGuid"] = dataRow.IsNull("LocalSupplierGuid") ? Guid.Empty : (Guid) dataRow["LocalSupplierGuid"];
				this.InactivateDate  = dtRow.IsNull(TABLE.PatientTransfusionRequirement.InactivateDate) ? System.DateTime.MinValue : (System.DateTime) dtRow[TABLE.PatientTransfusionRequirement.InactivateDate];
			}
			if (dtRow.Table.Columns.Contains(TABLE.PatientTransfusionRequirement.InactivateUser))
			{
				this.InactivateUser  = dtRow[TABLE.PatientTransfusionRequirement.InactivateUser].ToString();
			}
			if (dtRow.Table.Columns.Contains(TABLE.PatientTransfusionRequirement.InactivateDivisionCode))
			{
				this.InactivateDivisionCode = dtRow[TABLE.PatientTransfusionRequirement.InactivateDivisionCode].ToString();
			}
			if (dtRow.Table.Columns.Contains(TABLE.PatientTransfusionRequirement.SpecimenTestGuid))
			{
				this.SpecimenTestGuid = dtRow.IsNull(TABLE.PatientTransfusionRequirement.SpecimenTestGuid) ? Guid.Empty : (Guid) dtRow[TABLE.PatientTransfusionRequirement.SpecimenTestGuid];
			}
			if (dtRow.Table.Columns.Contains(TABLE.PatientTransfusionRequirement.RecordStatusCode))
			{
				this.RecordStatusCode = Common.Utility.GetRecordStatusCodeFromString(dtRow[TABLE.PatientTransfusionRequirement.RecordStatusCode].ToString());
			}
			if (dtRow.Table.Columns.Contains(TABLE.PatientTransfusionRequirement.LastUpdateDate))
			{
				this.LastUpdateDate = (System.DateTime) dtRow[TABLE.PatientTransfusionRequirement.LastUpdateDate];
			}
			if (dtRow.Table.Columns.Contains(TABLE.PatientTransfusionRequirement.RowVersion))
			{
				if (!dtRow.IsNull(TABLE.PatientTransfusionRequirement.RowVersion))
				{
					this.RowVersion = (byte[]) dtRow[TABLE.PatientTransfusionRequirement.RowVersion];
				}
			}
		}


		#endregion

	}
}
